/*
 * Decompiled with CFR 0.152.
 */
package com.talpie.linker;

import com.talpie.linker.ClientHandler;
import com.talpie.linker.DataSocketServer;
import com.talpie.linker.Message;
import com.talpie.linker.ServerListeners;
import com.talpie.linker.StreamFrame;
import com.talpie.linker.StreamSocketServer;
import java.sql.Timestamp;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class ServerListenersHandler {
    private final Set<String> openDs = ConcurrentHashMap.newKeySet();
    private final Set<String> openStreams = ConcurrentHashMap.newKeySet();
    private final CopyOnWriteArrayList<ServerListeners.Lifecycle> lifecycle = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ServerListeners.Connection> connection = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ServerListeners.DataSocket> dataSocket = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ServerListeners.ControlMessage> controlMsg = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ServerListeners.DataMessage> dataMsg = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ServerListeners.Progress> progress = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ServerListeners.Ping> ping = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ServerListeners.StreamSocket> streamSocket = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ServerListeners.StreamMessage> streamMsg = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ServerListeners.StreamProgress> streamProgress = new CopyOnWriteArrayList();

    public AutoCloseable register(ServerListeners.Lifecycle l) {
        this.lifecycle.add(l);
        return () -> this.lifecycle.remove(l);
    }

    public AutoCloseable register(ServerListeners.Connection l) {
        this.connection.add(l);
        return () -> this.connection.remove(l);
    }

    public AutoCloseable register(ServerListeners.DataSocket l) {
        this.dataSocket.add(l);
        return () -> this.dataSocket.remove(l);
    }

    public AutoCloseable register(ServerListeners.ControlMessage l) {
        this.controlMsg.add(l);
        return () -> this.controlMsg.remove(l);
    }

    public AutoCloseable register(ServerListeners.DataMessage l) {
        this.dataMsg.add(l);
        return () -> this.dataMsg.remove(l);
    }

    public AutoCloseable register(ServerListeners.Progress l) {
        this.progress.add(l);
        return () -> this.progress.remove(l);
    }

    public AutoCloseable register(ServerListeners.Ping l) {
        this.ping.add(l);
        return () -> this.ping.remove(l);
    }

    public AutoCloseable register(ServerListeners.StreamSocket l) {
        this.streamSocket.add(l);
        return () -> this.streamSocket.remove(l);
    }

    public AutoCloseable register(ServerListeners.StreamMessage l) {
        this.streamMsg.add(l);
        return () -> this.streamMsg.remove(l);
    }

    public AutoCloseable register(ServerListeners.StreamProgress l) {
        this.streamProgress.add(l);
        return () -> this.streamProgress.remove(l);
    }

    public CopyOnWriteArrayList<ServerListeners.Lifecycle> lifecycle() {
        return this.lifecycle;
    }

    public CopyOnWriteArrayList<ServerListeners.Connection> connection() {
        return this.connection;
    }

    public CopyOnWriteArrayList<ServerListeners.DataSocket> dataSocket() {
        return this.dataSocket;
    }

    public CopyOnWriteArrayList<ServerListeners.ControlMessage> control() {
        return this.controlMsg;
    }

    public CopyOnWriteArrayList<ServerListeners.DataMessage> data() {
        return this.dataMsg;
    }

    public CopyOnWriteArrayList<ServerListeners.Progress> progress() {
        return this.progress;
    }

    public CopyOnWriteArrayList<ServerListeners.Ping> ping() {
        return this.ping;
    }

    public CopyOnWriteArrayList<ServerListeners.StreamSocket> streamSocket() {
        return this.streamSocket;
    }

    public CopyOnWriteArrayList<ServerListeners.StreamMessage> stream() {
        return this.streamMsg;
    }

    public CopyOnWriteArrayList<ServerListeners.StreamProgress> streamProgress() {
        return this.streamProgress;
    }

    public void start(Object caller) {
        Timestamp ts = ServerListenersHandler.now();
        this.lifecycle.forEach(l -> ServerListenersHandler.safe(() -> l.onStart(caller, ts)));
    }

    public void stop(Object caller) {
        Timestamp ts = ServerListenersHandler.now();
        this.lifecycle.forEach(l -> ServerListenersHandler.safe(() -> l.onStop(caller, ts)));
    }

    public void error(Object caller, Throwable err) {
        Timestamp ts = ServerListenersHandler.now();
        this.lifecycle.forEach(l -> ServerListenersHandler.safe(() -> l.onError(caller, ts, err)));
    }

    public void clientConnected(Object caller, ClientHandler ch) {
        Timestamp ts = ServerListenersHandler.now();
        this.connection.forEach(l -> ServerListenersHandler.safe(() -> l.onClientConnected(caller, ts, ch)));
    }

    public void clientDisconnected(Object caller, ClientHandler ch, Throwable cause) {
        Timestamp ts = ServerListenersHandler.now();
        this.connection.forEach(l -> ServerListenersHandler.safe(() -> l.onClientDisconnected(caller, ts, ch, cause)));
    }

    public void handshakeCompleted(Object caller, ClientHandler ch) {
        Timestamp ts = ServerListenersHandler.now();
        this.connection.forEach(l -> ServerListenersHandler.safe(() -> l.onHandshakeCompleted(caller, ts, ch)));
    }

    public void handshakeFailed(Object caller, ClientHandler ch, Throwable cause) {
        Timestamp ts = ServerListenersHandler.now();
        this.connection.forEach(l -> ServerListenersHandler.safe(() -> l.onHandshakeFailed(caller, ts, ch, cause)));
    }

    public void dataOpen(Object caller, ClientHandler ch, DataSocketServer ds) {
        if (this.openDs.add(ds.getId())) {
            Timestamp ts = ServerListenersHandler.now();
            for (ServerListeners.DataSocket l : this.dataSocket) {
                ServerListenersHandler.safe(() -> l.onOpen(caller, ts, ch, ds));
            }
        }
    }

    public void dataClose(Object caller, ClientHandler ch, DataSocketServer ds) {
        if (this.openDs.remove(ds.getId())) {
            Timestamp ts = ServerListenersHandler.now();
            for (ServerListeners.DataSocket l : this.dataSocket) {
                ServerListenersHandler.safe(() -> l.onClose(caller, ts, ch, ds));
            }
        }
    }

    public void dataHandshakeCompleted(Object caller, ClientHandler ch, DataSocketServer ds) {
        Timestamp ts = ServerListenersHandler.now();
        this.dataSocket.forEach(l -> ServerListenersHandler.safe(() -> l.onHandshakeCompleted(caller, ts, ch, ds)));
    }

    public void dataHandshakeFailed(Object caller, ClientHandler ch, DataSocketServer ds, Throwable cause) {
        Timestamp ts = ServerListenersHandler.now();
        this.dataSocket.forEach(l -> ServerListenersHandler.safe(() -> l.onHandshakeFailed(caller, ts, ch, ds, cause)));
    }

    public Message controlRequest(Object caller, ClientHandler ch, Message msg) throws Exception {
        Timestamp ts = ServerListenersHandler.now();
        for (ServerListeners.ControlMessage l : this.controlMsg) {
            try {
                Message resp = l.onRequest(caller, ts, ch, msg);
                if (resp == null) continue;
                return resp;
            }
            catch (Throwable t) {
                this.error(caller, t);
            }
        }
        return null;
    }

    public Message controlResponse(Object caller, ClientHandler ch, Message msg) throws Exception {
        Timestamp ts = ServerListenersHandler.now();
        for (ServerListeners.ControlMessage l : this.controlMsg) {
            try {
                Message resp = l.onResponse(caller, ts, ch, msg);
                if (resp == null) continue;
                return resp;
            }
            catch (Throwable t) {
                this.error(caller, t);
            }
        }
        return null;
    }

    public Message controlPing(Object caller, ClientHandler ch, Message msg) throws Exception {
        Timestamp ts = ServerListenersHandler.now();
        for (ServerListeners.Ping l : this.ping) {
            try {
                Message resp = l.onPing(caller, ts, ch, msg);
                if (resp == null) continue;
                return resp;
            }
            catch (Throwable t) {
                this.error(caller, t);
            }
        }
        return null;
    }

    public Message dataRequest(Object caller, ClientHandler ch, DataSocketServer ds, Message msg) throws Exception {
        Timestamp ts = ServerListenersHandler.now();
        for (ServerListeners.DataMessage l : this.dataMsg) {
            try {
                Message resp = l.onRequest(caller, ts, ch, ds, msg);
                if (resp == null) continue;
                return resp;
            }
            catch (Throwable t) {
                this.error(caller, t);
            }
        }
        return null;
    }

    public Message dataResponse(Object caller, ClientHandler ch, DataSocketServer ds, Message msg) throws Exception {
        Timestamp ts = ServerListenersHandler.now();
        for (ServerListeners.DataMessage l : this.dataMsg) {
            try {
                Message resp = l.onResponse(caller, ts, ch, ds, msg);
                if (resp == null) continue;
                return resp;
            }
            catch (Throwable t) {
                this.error(caller, t);
            }
        }
        return null;
    }

    public void progressRx(Object caller, ClientHandler ch, Message m, long recvd, long total, int pct) {
        Timestamp ts = ServerListenersHandler.now();
        this.progress.forEach(l -> ServerListenersHandler.safe(() -> l.onProgressReceiving(caller, ts, ch, m, recvd, total, pct)));
    }

    public void progressTx(Object caller, ClientHandler ch, Message m, long sent, long total, int pct) {
        Timestamp ts = ServerListenersHandler.now();
        this.progress.forEach(l -> ServerListenersHandler.safe(() -> l.onProgressTransmitting(caller, ts, ch, m, sent, total, pct)));
    }

    public void progressDataRx(Object caller, ClientHandler ch, DataSocketServer ds, Message m, long recvd, long total, int pct) {
        Timestamp ts = ServerListenersHandler.now();
        this.progress.forEach(l -> ServerListenersHandler.safe(() -> l.onProgressDataReceiving(caller, ts, ch, ds, m, recvd, total, pct)));
    }

    public void progressDataTx(Object caller, ClientHandler ch, DataSocketServer ds, Message m, long sent, long total, int pct) {
        Timestamp ts = ServerListenersHandler.now();
        this.progress.forEach(l -> ServerListenersHandler.safe(() -> l.onProgressDataTransmitting(caller, ts, ch, ds, m, sent, total, pct)));
    }

    public void streamOpen(Object caller, ClientHandler ch, StreamSocketServer ss, String streamId) {
        Timestamp ts = ServerListenersHandler.now();
        this.streamSocket.forEach(l -> ServerListenersHandler.safe(() -> l.onOpen(caller, ts, ch, ss)));
    }

    public void streamClose(Object caller, ClientHandler ch, StreamSocketServer ss, String streamId) {
        Timestamp ts = ServerListenersHandler.now();
        this.streamSocket.forEach(l -> ServerListenersHandler.safe(() -> l.onClose(caller, ts, ch, ss)));
    }

    public void streamHandshakeCompleted(Object caller, ClientHandler ch, StreamSocketServer ss, String streamId) {
        Timestamp ts = ServerListenersHandler.now();
        this.streamSocket.forEach(l -> ServerListenersHandler.safe(() -> l.onHandshakeCompleted(caller, ts, ch, ss, streamId)));
    }

    public void streamHandshakeFailed(Object caller, ClientHandler ch, StreamSocketServer ss, String streamId, Throwable cause) {
        Timestamp ts = ServerListenersHandler.now();
        this.streamSocket.forEach(l -> ServerListenersHandler.safe(() -> l.onHandshakeFailed(caller, ts, ch, ss, streamId, cause)));
    }

    public void streamMeta(Object caller, ClientHandler ch, StreamSocketServer ss, String streamId, byte[] meta) {
        Timestamp ts = ServerListenersHandler.now();
        this.streamMsg.forEach(l -> ServerListenersHandler.safe(() -> l.streamMeta(caller, ts, ch, ss, streamId, meta)));
    }

    public void streamFrameIn(Object caller, ClientHandler ch, StreamSocketServer ss, StreamFrame f, long bytesOnWire) {
        Timestamp ts = ServerListenersHandler.now();
        this.streamMsg.forEach(l -> ServerListenersHandler.safe(() -> l.streamFrameIn(caller, ts, ch, ss, f, bytesOnWire)));
    }

    public void streamFrameOut(Object caller, ClientHandler ch, StreamSocketServer ss, StreamFrame f, long bytesOnWire) {
        Timestamp ts = ServerListenersHandler.now();
        this.streamMsg.forEach(l -> ServerListenersHandler.safe(() -> l.streamFrameOut(caller, ts, ch, ss, f, bytesOnWire)));
    }

    public void streamProgressRx(Object caller, ClientHandler ch, StreamSocketServer ss, long frames, long totalBytesOnWire) {
        Timestamp ts = ServerListenersHandler.now();
        this.streamProgress.forEach(l -> ServerListenersHandler.safe(() -> l.streamProgressRx(caller, ts, ch, ss, frames, totalBytesOnWire)));
    }

    public void streamProgressTx(Object caller, ClientHandler ch, StreamSocketServer ss, long frames, long totalBytesOnWire) {
        Timestamp ts = ServerListenersHandler.now();
        this.streamProgress.forEach(l -> ServerListenersHandler.safe(() -> l.streamProgressTx(caller, ts, ch, ss, frames, totalBytesOnWire)));
    }

    private static Timestamp now() {
        return new Timestamp(System.currentTimeMillis());
    }

    private static void safe(Runnable r) {
        try {
            r.run();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

